package com.ElyStudio.leGaou.adapter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.models.Leaderboard;

import java.util.List;

public class LeaderboardAdapter extends RecyclerView.Adapter<LeaderboardAdapter.LeaderboardViewHolder> {

    List<Leaderboard> leaderboardList;

    public LeaderboardAdapter(List<Leaderboard> leaderboardList) {
        this.leaderboardList = leaderboardList;
    }

    @NonNull
    @Override
    public LeaderboardAdapter.LeaderboardViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new LeaderboardViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.leaderboard_list_layout,parent,false));
    }

    @Override
    public void onBindViewHolder(@NonNull LeaderboardAdapter.LeaderboardViewHolder holder, int position) {
        Leaderboard leaderboard = leaderboardList.get(position);

        holder.userRank.setText(String.valueOf(position+1));
        holder.userName.setText(leaderboard.getName());
        holder.userCoins.setText(String.valueOf(leaderboard.getCoins()));

    }

    @Override
    public int getItemCount() {
        return leaderboardList.size();
    }

    public static class LeaderboardViewHolder extends RecyclerView.ViewHolder {
        TextView userRank,userName,userCoins;
        public LeaderboardViewHolder(@NonNull View itemView) {
            super(itemView);

            userRank = itemView.findViewById(R.id.leaderboardUserRank);
            userName = itemView.findViewById(R.id.leaderboardUserName);
            userCoins = itemView.findViewById(R.id.leaderboardUserCoins);

        }
    }
}
